<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Dashboard extends BaseModel
{
    //use HasFactory;

    protected $dateStart;
    protected $dateEnd;
    protected $company;

    public function __construct(array $attributes = [])
    {
        $this->dateStart = Carbon::parse($attributes['dateStart']);
        $this->dateEnd = Carbon::parse($attributes['dateEnd'])->addDays(1);
        $this->company = isset($attributes['company']) ? $attributes['company'] : auth()->user()->company ;
    }

    public function rdvs(){
        return
//            (auth()->user()->isDoctor())
//                ?
//                Rdv::where('datetime', '>=', $this->dateStart)->where('datetime', '<=', $this->dateEnd)->where('company_id', $this->company->id)->whereUserId(auth()->user()->id)->count()
//                :
                Rdv::where('datetime', '>=', $this->dateStart)->where('datetime', '<=', $this->dateEnd)->where('company_id', $this->company->id)->count();
    }

    public function patients(){
        return Patient::where('created_at', '>=', $this->dateStart)->where('created_at', '<=', $this->dateEnd)->where('company_id', $this->company->id)->count();
    }

    public function operations(){
        $interventions = Intervention::where('datetimefrom', '>=', $this->dateStart)->where('datetimefrom', '<=', $this->dateEnd)->where('company_id', $this->company->id)->get();
        $total = 0;
        foreach($interventions as $intervention){
            $total += $intervention->cares->where('name', 'Chirurgie')->count();
//            if($intervention->care->name == 'Chirurgie')
//                $total++;
        }
        return $total;
    }

    public function recipe(){
        $invoices = Invoice::where('created_at', '>=', $this->dateStart)->where('created_at', '<=', $this->dateEnd)->where('company_id', $this->company->id)->get();
        $total = 0;
        foreach ($invoices as $invoice){
            $total += $invoice->total;
        }
        return number_format($total, 0, '', ' ');
    }

    public function charts($name, $month){
        $dateStart = date('Y-'.$month.'-01');
        $dateEnd = date('Y-'.$month.'-31');
        $interventions = Intervention::where('datetimefrom', '>=', $dateStart)->where('datetimefrom', '<=', $dateEnd)->where('company_id', $this->company->id)->get();
        $total = 0;
        foreach($interventions as $intervention){
            if($intervention->status->name == $name)
                $total++;
        }
//        return $total;
        return rand(0, 100);
    }

    public function consultations(){
        $consultations = Consultation::where('datetime', '>=', $this->dateStart)->where('datetime', '<=', $this->dateEnd)->where('company_id', $this->company->id)->count();
        return $consultations;
    }

    public function interventions(){
        $interventions = Intervention::where('datetimefrom', '>=', $this->dateStart)->where('datetimefrom', '<=', $this->dateEnd)->where('company_id', $this->company->id)->count();
        return $interventions;
    }

}
