<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Consultation extends BaseModel
{
    use HasFactory;

    protected $table = 'consultations';

    protected $fillable = [
        'description',
        'datetime',
        'typeconsultation_id',
        'temperature',
        'amount',
        'patient_id',
        'user_id',
        'sale_id',
        'company_id',
        'custom_id',
        'prescription',
        'tension'
    ];

    protected $dates = ['datetime'];

    public function patient(){
        return $this->belongsTo(Patient::class);
    }

    public function user(){
        return $this->belongsTo(User::class);
    }

    public function invoice(){
        return Invoice::where('consultation_id', $this->id)->first();
    }
}
