<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Company extends BaseModel
{
    use HasFactory;

    protected $table = 'companies';

    protected $fillable = [
        'name',
        'doctor',
        'diploma',
        'logo',
        'header',
        'footer',
        'ticket_amount',
        'tel',
        'adresse',
        'subscription_id',
        'subscription_active',
        'last_subscription_date',
        'bp',
        'custom_id',
        'signature',
        'tva',
        'country',
        'city',
        'subscriber_id',
        'currency',
        'currency_symbol',
        'tva_value',
        'ai_credits',
    ];

    protected $appends = ['days_left'];

    public function getDaysLeftAttribute(){
        $days = 30;
        $today = Carbon::today();
        if($this->last_subscription_date){
            $days = $days - ($today->diffInDays(Carbon::parse($this->last_subscription_date)));
        }else{
            $days = $days - ($today->diffInDays(Carbon::parse($this->created_at)));
        }
        return ($days > 0) ? $days : 0 ;
    }
    public function subscription(){
        return $this->belongsTo(Subscription::class);
    }
    public function users(){
        return $this->hasMany(User::class);
    }
    public function isUsersMax(){
        if($this->subscription AND $this->subscription->name == 'basic' AND $this->users->count() >= 5)
            return true;
        if($this->subscription AND $this->subscription->name == 'standard' AND $this->users->count() >= 10)
            return true;
        return false;
    }
    public function subscriber(){
        return $this->belongsTo(User::class, 'subscriber_id');
    }

    public function subscriptionInvoices(){
        return $this->hasMany(SubscriptionInvoice::class);
    }

    public function latestSubscriptionInvoice()
    {
        return $this->hasOne(SubscriptionInvoice::class)->latest();
    }
}
