<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Command extends BaseModel
{
    use HasFactory;

    protected $table = 'commands';

    protected $fillable = [
        'qte',
        'product_id',
        'sale_id',
        'company_id',
        'custom_id'
    ];

    protected $appends = ['price'];

    public function product(){
        return $this->belongsTo(Product::class);
    }

    public function getPriceAttribute(){
        return $this->qte * $this->product->selling_price;
    }

}
