<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BaseModel extends Model
{
    use HasFactory;

    public function monthToFr($date = null){
        $months = [
            '01' => 'Janvier',
            '02' => 'Février',
            '03' => 'Mars',
            '04' => 'Avril',
            '05' => 'Mai',
            '06' => 'Juin',
            '07' => 'Juillet',
            '08' => 'Août',
            '09' => 'Septembre',
            '10' => 'Octobre',
            '11' => 'Novembre',
            '12' => 'Décembre',
        ];
        return ($date) ? $this->allMonths()[$date->format('m')] : $this->allMonths()[$this->created_at->format('m')];
    }

    public static function allMonths(){
        return [
            '01' => 'Janvier',
            '02' => 'Février',
            '03' => 'Mars',
            '04' => 'Avril',
            '05' => 'Mai',
            '06' => 'Juin',
            '07' => 'Juillet',
            '08' => 'Août',
            '09' => 'Septembre',
            '10' => 'Octobre',
            '11' => 'Novembre',
            '12' => 'Décembre',
        ];
    }

    public static function monthsPassed(){
        $monthsPassed = [];
        foreach(self::allMonths() as $key => $month){
            $monthsPassed[$key] = $month;
            if($key == date('m', strtotime('+1 month')) AND $key != '01'){
                break;
            }
        }
        return $monthsPassed;
    }

    public static function findBySlug($slug)
    {
        return static::where('custom_id', $slug)->first();
    }
}
