<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class TeleconsultationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $data;

    /**
     * Create a new message instance.
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $pdfTeleconsultation = app()->make('App\Http\Controllers\Admin\InvoiceController')->generatePDF($this->data['teleconsultation']->invoice()->custom_id, 'teleconsultation');
        $pdfPrescription = app()->make('App\Http\Controllers\Admin\InvoiceController')->generatePDF($this->data['teleconsultation']->invoice()->custom_id, 'prescription');
        $company = auth()->user()->company;

        return $this->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME'))
            ->subject('KONDY · Rapport de Téléconsultation')
            ->view('emails.teleconsultation', $this->data)
            ->attachData($pdfTeleconsultation, 'KONDY_'.$company->name.'_Facture_Teleconsultation.pdf', [
                'mime' => 'application/pdf',
            ])
            ->attachData($pdfPrescription, 'KONDY_'.$company->name.'_Ordonnance_Téléconsultation.pdf', [
                'mime' => 'application/pdf',
            ]);

    }
}
