<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class TraitantMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if(!auth()->user()->isTraitant() AND !auth()->user()->isAdmin() AND !auth()->user()->isSA())
            return redirect(route('404'));
        return $next($request);
    }
}
