<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SubStandardMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $subs = ['standard', 'gold'];
        if(auth()->user()->company->subscription AND !in_array(auth()->user()->company->subscription->name, $subs))
            return redirect(route('404'));
        return $next($request);
    }
}
