<?php

namespace App\Http\Controllers;
use App\Http\Controllers\controller;

use App\Models\Company;
use App\Models\Specialty;
use App\Models\Subscription;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;

class UserController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
//            'name' => 'required|string|max:255',
//            'email' => 'required|email|unique:users',
//            'password' => 'required|string|min:8|confirmed',
        ]);
        if ($validator->fails()) {
            return Redirect::back()
                ->withErrors($validator)
                ->withInput();
        }
        $data = $request->all();

        $isDoctor = (isset($data['is_doctor'])) ? true : false;

        // insert User
        $data['password'] = Hash::make($data['password']);
        $data['active'] = true;
        $data['position'] = 'Directeur Général';
        $data['profil'] = 'super admin';
        $data['is_doctor'] = $isDoctor;
        $data['custom_id'] = $this->generateCustomID();
        $user = User::create($data);

        // insert Company
        $data['name'] = $data['clinical_name'];
        $data['tel'] = $data['clinical_tel'];
        $data['trial'] = true;
        $data['subscription_active'] = false;
        $data['ticket_amount'] = 0;
        $data['doctor'] = $isDoctor ? $user->name : $data['doctor'];
        $data['custom_id'] = $this->generateCustomID();
        $data['subscriber_id'] = $user->id;

        // set currencies
        $currencyData = $this->setCurrency($data['country']);
        $data['currency'] = $currencyData[0];
        $data['currency_symbol'] = $currencyData[1];

        // set TVA
        $data['tva_value'] = $this->setTVA($data['country']);

        if($data['subscription_id'] == 2)
            $data['ai_credits'] = 50;

        $company = Company::create($data);

        // insert Cares
        $cares = [
            'Frais basique',
            'Soins d\'urgence',
            'Analyse de laboratoire',
            'Radiographie',
            'Echographie',
            'Chirurgie',
            'Anesthésie',
            'Soins intensifs',
            'Oncologie',
            'Soins infirmiers',
            'Examens médicaux',
            'Pédiatrie',
            'Gastro-entérologie',
            'Néphrologie',
            'Pneumologie',
            'Neurologie',
            'Endocrinologie',
            'Dermatologie',
            'Physiothérapie/rééducation',
            'Imagerie médicale',
        ];

        foreach($cares as $care){
            \App\Models\Care::create([
                'name' => $care,
                'amount' => 0,
                'company_id' => $company->id,
                'custom_id' => $this->generateCustomID(),
            ]);
        }


        // update User
        $user->company_id = $company->id;
        $user->save();

        Auth::loginUsingId($user->id);
//        return redirect('/admin');
        $paymentInfosSup = $data['payment_infos_sup'] ? urlencode($data['payment_infos_sup']) : null;
        return redirect(route('subscribe.paiementRenew', [$company, $company->subscription, 'trial', $data['annual'], $data['subscription_mode'], $paymentInfosSup, $request]));
    }

    private function storeFile($file){
        $name = $file->hashName();
        $file->move(storage_path('app/public/uploads/users'), $name);
        return $name;
    }

    public function checkPassword(User $user, Request $request)
    {
        $password = $request->get('password');
        if(password_verify($password, $user->password))
            return true;
        return false;
    }

    public function subscribe($id){
        $subscription = Subscription::find($id);
        return view('auth.register', compact('subscription'));
    }
}
