<?php

namespace App\Http\Controllers;

use App\Models\SubscriptionInvoice;
use Illuminate\Http\Request;
use Stripe\Checkout\Session;
use Stripe\Customer;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use Stripe\Subscription;
use Stripe\Exception;

class StripeController extends Controller
{
    public function createPaymentIntent(Request $request)
    {
        Stripe::setApiKey(config('services.stripe.secret'));

        $paymentIntent = PaymentIntent::create([
            'amount' => 2000, // Montant en cents
            'currency' => 'eur',
            'payment_method_types' => ['card'],
        ]);

        return response()->json(['clientSecret' => $paymentIntent->client_secret]);
    }

    public function createCheckoutSession(){
        Stripe::setApiKey(config('services.stripe.secret'));

        $session = Session::create([
            'payment_method_types' => ['card'],
            'line_items' => [[
                'price_data' => [
                    'currency' => 'eur',
                    'product_data' => [
                        'name' => 'Offre GOLD',
                    ],
                    'unit_amount' => 149999,
                    'recurring' => [
                        'interval' => 'month',
                    ],
                ],
                'quantity' => 1,
            ]],
            'mode' => 'subscription',
            'success_url' => url('/success'),
            'cancel_url' => url('/cancel'),
        ]);

        return response()->json(['id' => $session->id]);
    }

    public function createSubscription(Request $request){

        Stripe::setApiKey(config('services.stripe.secret'));

        try {
            // Rechercher le client par email
            $customers = \Stripe\Customer::all(['email' => $request->email]);

            if (count($customers->data) > 0) {
                // Le client existe
                $customer = $customers->data[0];

                // Vérifier les abonnements du client
                $subscriptions = Subscription::all(['customer' => $customer->id]);
                if (count($subscriptions->data) > 0) {
                    // L'utilisateur a un abonnement existant
                    $subscription = $subscriptions->data[0];
                    if ($subscription->status === 'canceled') {
                        // Réactiver l'abonnement annulé
                        $updatedSubscription = Subscription::update($subscription->id, [
                            'items' => [['price' => $request->price_id]],
//                            'trial_period_days' => 30, // Définir la période d'essai si nécessaire
                        ]);
                        return response()->json(['success' => true, 'subscription' => $updatedSubscription]);
                    }
                } else {
                    // Créer un nouvel abonnement si aucun abonnement existant n'est trouvé
                    $subscription = Subscription::create([
                        'customer' => $customer->id,
                        'items' => [['price' => $request->price_id]],
                        'trial_period_days' => 30, // Définir la période d'essai si nécessaire
                    ]);
                    return response()->json(['success' => true, 'subscription' => $subscription]);
                }
            } else {
                // Create Customer
                $customer = Customer::create([
                    'payment_method' => $request->payment_method,
                    'email' => $request->email, // Remplacez par l'email de l'utilisateur
                    'name' => $request->name, // Remplacez par le nom de l'utilisateur
                    'invoice_settings' => [
                        'default_payment_method' => $request->payment_method
                    ],
                ]);

                // Create Subscription
                $subscription = Subscription::create([
                    'customer' => $customer->id,
                    'items' => [
                        [
                            'price' => $request->price_id, // Remplacez par l'ID de votre prix Stripe
                        ],
                    ],
                    'trial_period_days' => 30, // Set trial period to 30 days
                    'expand' => ['latest_invoice.payment_intent'],
                ]);
                return response()->json(['success' => true, 'subscription' => $subscription]);
            }

        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 400);
        }
    }

    public static function checkSubscriptionStatus($customerEmail){
        Stripe::setApiKey(config('services.stripe.secret'));

//        $customerEmail = $request->input('email');

        // Rechercher le client par email
        $customers = \Stripe\Customer::all(['email' => $customerEmail]);

        if (count($customers->data) > 0) {
            $customer = $customers->data[0];

            // Récupérer les abonnements du client
            $subscriptions = Subscription::all(['customer' => $customer->id]);

            if (count($subscriptions->data) > 0) {
                $subscription = $subscriptions->data[0];
                if ($subscription->status === 'active') {
                    return 'active';
                } elseif ($subscription->status === 'canceled') {
                    $subscriptionInvoice = SubscriptionInvoice::where('card_email', $customerEmail)->where('stripe_id', $subscription->id)->orderBy('id', 'desc')->first();
                    $subscriptionInvoice->company->subscription_active = false;
                    $subscriptionInvoice->company->save();
                    return 'canceled';
                } else {
                    return $subscription->status;
                }
            } else {
                return 'no_subscription';
            }
        } else {
            return 'no_customer';
        }
    }
}
