<?php

namespace App\Http\Controllers;

use App\Mail\CancellationMail;
use App\Models\Company;
use App\Models\SubscriptionInvoice;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Srmklive\PayPal\Services\PayPal as PayPalClient;

class PayPalController extends Controller
{
    public function createSubscription(Request $request)
    {
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $token = $provider->getAccessToken();

        $subscription = $provider->createSubscription([
            'plan_id' => $request->get('planID'), // Votre plan ID PayPal
            'application_context' => [
                'brand_name' => 'KONDY',
                'locale' => 'fr-FR',
                'shipping_preference' => 'NO_SHIPPING',
                'user_action' => 'SUBSCRIBE_NOW',
                'return_url' => route('paypal.subscription.success'),
                'cancel_url' => route('paypal.subscription.cancel'),
            ],
            'subscriber' => [
                'name' => [
                    'given_name' => $request->input('given_name'),
//                    'surname' => $request->input('last_name'),
                ],
                'email_address' => $request->input('email'),
            ],
        ]);

        return response()->json($subscription);
    }

    public function subscriptionSuccess(Request $request)
    {
        // Traiter la réussite de l'abonnement
        return view('subscription.success');
    }

    public function subscriptionCancel()
    {
        // Traiter l'annulation de l'abonnement
        return view('subscription.cancel');
    }

    public function handleWebhook(Request $request)
    {
        $payload = $request->all();

        // Enregistrer les événements reçus pour le débogage
        Log::info('Webhook received from PayPal:', $payload);

        // Vérifier l'événement spécifique
        switch ($payload['event_type']) {
            case 'BILLING.SUBSCRIPTION.CREATED':
                // Traiter la création d'abonnement
                $subscriberInfo = $payload['resource']['subscriber'];
                $subscriptionId = $payload['resource']['id'];

                // Sauvegarder les informations du subscriber dans la base de données
                // (à adapter selon votre modèle)
                // Exemple :
                // Subscriber::create([
                //     'subscription_id' => $subscriptionId,
                //     'first_name' => $subscriberInfo['name']['given_name'],
                //     'last_name' => $subscriberInfo['name']['surname'],
                //     'email' => $subscriberInfo['email_address'],
                // ]);

                break;

            case 'PAYMENT.SALE.COMPLETED':
                // Traiter les paiements réussis
                $paymentInfo = $payload['resource'];
                $subscriptionId = $paymentInfo['billing_agreement_id'];

                // Enregistrer le paiement dans la base de données, etc.

                break;

            case 'BILLING.SUBSCRIPTION.CANCELLED':
                // Traiter l'annulation d'abonnement
                $subscriptionId = $payload['resource']['id'];
                // Mettre à jour l'état de l'abonnement dans la base de données
                $subscriptionInvoice = SubscriptionInvoice::where('paypal_id', $subscriptionId)->orderBy('id', 'desc')->first();
                $subscriptionInvoice->company->subscription_active = false;
                $subscriptionInvoice->company->save();
                // envoyer un mail d'annulation d'abonnement
                $mailData = [
                    'user' => auth()->user(),
                    'company' => auth()->user()->company,
                    'latestSubscriptionInvoice' => auth()->user()->company->latestSubscriptionInvoice,
                    'date' => Carbon::now()->translatedFormat('D d F Y')
                ];
                Mail::to($subscriptionInvoice->company->subscriber)->send(new CancellationMail($mailData));
                break;

            // Ajouter d'autres cas si nécessaire
        }

        // Répondre avec un statut 200 pour informer PayPal que le webhook a été bien reçu
        return response()->json(['status' => 'success'], 200);
    }



}
