<?php

namespace App\Http\Controllers;

use App\Mail\RegistrationMail;
use App\Models\Company;
use App\Models\Subscription;
use App\Models\SubscriptionInvoice;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
//        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return redirect('/admin');
//        return view('site.index');
    }

    public function showRenew($company){
        $company = Company::findBySlug($company);
        $company->last_date = $company->last_subscription_date ? Carbon::parse($company->last_subscription_date) : Carbon::parse($company->created_at)->addDays(30);
        $company->last_date = $company->last_date->translatedFormat('D d F Y');
        $lastSubscriptionInvoice = SubscriptionInvoice::whereCompanyId($company->id)->orderBy('id', 'desc')->first();

        // GET SUBSCRIPTION INFOS
        $subscription = Subscription::find($company->subscription_id);
        if($subscription->name == 'basic'){
            $subscription->color = '#3f51b5';
            $subscription->bgcolor = 'aliceblue';
        }elseif($subscription->name == 'standard'){
            $subscription->color = '#03b106';
            $subscription->bgcolor = '#efe';
        }else{
            $subscription->color = '#b59a06';
            $subscription->bgcolor = '#fffce8';
        }
        return view('auth.renewSubscription', compact('company', 'subscription', 'lastSubscriptionInvoice'));
    }

    public function paiementRenew(Company $company, Subscription $subscription, $type, $annual, Request $request, $mode = 'stripe', $paymentInfosSup = null){
        $data = $request->all();
        $paymentInfosSupDecode = $paymentInfosSup ? json_decode($paymentInfosSup, true) : null;
        $paymentInfosSup = $paymentInfosSup ? urlencode($paymentInfosSup) : null;
        $save_url = route('subscribe.saveRenew', [$company, $subscription, $type, $annual, $mode, $paymentInfosSup, $request]);

        if(in_array($mode, ['stripe', 'paypal'])){
            return redirect($save_url);
        }

        $api_url = 'https://paygateglobal.com/v1/page';
        $token = env('PAYGATE_API_KEY');
        $phone = isset($paymentInfosSupDecode['tel']) ? $paymentInfosSupDecode['tel'] : auth()->user()->tel;
//        if($type == 'trial')
//            $amount = $subscription->trial_value;
//        else
//            $amount = $subscription->value;
        $amount = 1;

        $description = 'KONDY - Abonnement ' . strtoupper($subscription->name) . ' - ' .$company->name;
        $identifier = $company->id . date('Ymdhis');
        $format_url = $api_url . '?token=' . $token . '&amount=' . $amount . '&phone=' . $phone . '&description=' . $description . '&identifier=' . $identifier . '&url=' . $save_url;

        if($type == 'trial')
            return redirect($save_url);
        else
            return redirect($format_url);
    }

    public function saveRenew(Company $company, Subscription $subscription, $type, $annual, Request $request, $mode = 'stripe', $paymentInfosSup = null){
        $company->trial = ($type == 'trial');
        $company->subscription_id = $subscription->id;
        $company->subscription_active = true;
        $company->last_subscription_date = Carbon::now();
        if($subscription->id == 2)
            $company->ai_credits = 50;
        $company->save();
        $paymentInfosSup = $paymentInfosSup ? json_decode($paymentInfosSup, true) : null;

        SubscriptionInvoice::create([
            'name' => 'KONDY - Abonnement ' . $subscription->name . ' - ' .$company->name,
            'amount_paid' => $annual ? $subscription->annual_total_value : $subscription->value,
            'currency' => $subscription->currency,
            'mode' => $mode,
            'company_id' => $company->id,
            'subscription_id' => $subscription->id,
            'custom_id' => $this->generateCustomID(),
            'card_name' => $paymentInfosSup ? str_replace("+", " ", $paymentInfosSup['name']) : null,
            'card_email' => $paymentInfosSup ? $paymentInfosSup['email'] : null,
            'tel' => $paymentInfosSup ? $paymentInfosSup['tel'] : null,
            'stripe_id' => ($paymentInfosSup AND isset($paymentInfosSup['stripe_id'])) ? $paymentInfosSup['stripe_id'] : null,
            'paypal_id' => ($paymentInfosSup AND isset($paymentInfosSup['paypal_id'])) ? $paymentInfosSup['paypal_id'] : null,
            'paygate_id' => ($paymentInfosSup AND isset($paymentInfosSup['paygate_id'])) ? $paymentInfosSup['paygate_id'] : null,
            'annual' => $annual,
        ]);

        $mailData = [
            'user' => auth()->user(),
            'trial' => ($type == 'trial'),
            'company' => auth()->user()->company,
            'latestSubscriptionInvoice' => auth()->user()->company->latestSubscriptionInvoice
        ];
        Mail::to($company->subscriber)->send(new RegistrationMail($mailData));

        return redirect(route('company.edit', $company->custom_id));
    }

    public function stripe($val, $currency = 'euro'){

    }

    public function paypal(){

    }

    public function paygate(){

    }


}
