<?php

namespace App\Http\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public function generateCustomID($length = 5){
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';

        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }

        return $randomString;
    }

    // START CURRENCY CONVERSION
    public function euro2xof($val){
        return $val * 655.9;
    }

    public function euro2dollar($val){
        return $val * 1.07;
    }

    public function xof2euro($val){
        return $val / 655.9;
    }

    public function xof2dollar($val){
        return $val / 611;
    }

    public function dollar2xof($val){
        return $val * 611;
    }

    public function dollar2euro($val){
        return $val  / 1.07;
    }
    // END CURRENCY CONVERSION

    public function setCurrency($country) {
        switch ($country) {
            case 'France':
            case 'Andorre':
            case 'Monaco':
            case 'Luxembourg':
            case 'Belgique':
                return ['Euro', '€'];

            case 'Algérie':
                return ['Dinar algérien', 'DZD'];

            case 'Bénin':
            case 'Burkina Faso':
            case 'Côte d\'Ivoire':
            case 'Guinée-Bissau':
            case 'Mali':
            case 'Niger':
            case 'Sénégal':
            case 'Togo':
                return ['Franc CFA (BCEAO)', 'FCFA'];

            case 'Burundi':
                return ['Franc burundais', 'BIF'];

            case 'Cameroun':
            case 'République Centrafricaine':
            case 'Congo (Brazzaville)':
            case 'Gabon':
            case 'Tchad':
                return ['Franc CFA (BEAC)', 'XAF'];

            case 'Canada':
                return ['Dollar canadien', '$CAD'];

            case 'Cap-Vert':
                return ['Escudo cap-verdien', 'CVE'];

            case 'Comores':
                return ['Franc comorien', 'KMF'];

            case 'Congo (Kinshasa)':
                return ['Franc congolais', 'CDF'];

            case 'Djibouti':
                return ['Franc djiboutien', 'DJF'];

            case 'Guinée':
                return ['Franc guinéen', 'GNF'];

            case 'Haïti':
                return ['Gourde haïtienne', 'HTG'];

            case 'Madagascar':
                return ['Ariary malgache', 'MGA'];

            case 'Maroc':
                return ['Dirham marocain', 'MAD'];

            case 'Maurice':
                return ['Roupie mauricienne', 'MUR'];

            case 'Mauritanie':
                return ['Ouguiya mauritanien', 'MRU'];

            case 'Rwanda':
                return ['Franc rwandais', 'RWF'];

            case 'Seychelles':
                return ['Roupie seychelloise', 'SCR'];

            case 'Suisse':
                return ['Franc suisse', 'CHF'];

            case 'Tunisie':
                return ['Dinar tunisien', 'TND'];

            case 'Vanuatu':
                return ['Vatu vanuatuan', 'VUV'];

            default:
                return ['Unknown', ''];
        }
    }

    public function setTVA($country) {
        switch ($country) {
            case 'France':
            case 'Monaco':
            case 'Madagascar':
            case 'Maroc':
                return 20; // 20% en France, Monaco, Madagascar et Maroc

            case 'Belgique':
                return 21; // 21% en Belgique

            case 'Andorre':
                return 4.5; // 4.5% en Andorre

            case 'Luxembourg':
                return 17; // 17% au Luxembourg

            case 'Algérie':
            case 'Tunisie':
                return 19; // 19% en Algérie et Tunisie

            case 'Bénin':
            case 'Burkina Faso':
            case 'Côte d\'Ivoire':
            case 'Guinée-Bissau':
            case 'Mali':
            case 'Niger':
            case 'Sénégal':
            case 'Togo':
            case 'Burundi':
            case 'Guinée':
            case 'Rwanda':
                return 18; // 18% pour ces pays

            case 'Cameroun':
            case 'République Centrafricaine':
            case 'Congo (Brazzaville)':
            case 'Gabon':
            case 'Tchad':
                return 19.25; // 19.25% pour ces pays utilisant le Franc CFA (BEAC)

            case 'Canada':
                return 5; // 5% de taxe fédérale, mais peut varier avec les taxes provinciales

            case 'Cap-Vert':
            case 'Vanuatu':
            case 'Seychelles':
            case 'Maurice':
                return 15; // 15% au Cap-Vert, Vanuatu, Seychelles et Maurice

            case 'Comores':
            case 'Djibouti':
            case 'Haïti':
                return 10; // 10% aux Comores, Djibouti et Haïti

            case 'Congo (Kinshasa)':
            case 'Mauritanie':
                return 16; // 16% en République démocratique du Congo et Mauritanie

            case 'Suisse':
                return 7.7; // 7.7% en Suisse

            default:
                return 0; // 0% par défaut pour les pays non spécifiés
        }
    }
}
