<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Verdict;
use Illuminate\Http\Request;

class VerdictController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Verdict::orderBy('id', 'desc')->get();
        return view('verdict.list', compact('datas'));
    }

    /**
     * Show the form for creating a new Http\Response
     */
    public function create()
    {
        return view('verdict.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['custom_id'] = $this->generateCustomID();
        Verdict::create($data);
        return $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Verdict  $verdict
     * @return \Illuminate\Http\Response
     */
    public function show(Verdict $verdict)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Verdict  $verdict
     * @return \Illuminate\Http\Response
     */
    public function edit(Verdict $verdict)
    {
        $data = Verdict::findBySlug($verdict);
        return view('verdict.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Verdict  $verdict
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Verdict $verdict)
    {
        $data = $request->all();
        $verdict->update($data);
        $verdict->save();
        return $this->index();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Verdict  $verdict
     * @return \Illuminate\Http\Response
     */
    public function destroy(Verdict $verdict)
    {
        $verdict = Verdict::findBySlug($verdict);
        $verdict->delete();
        return $this->index();
    }
}

