<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Typeintervention;
use Illuminate\Http\Request;

class TypeinterventionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Typeintervention::orderBy('id', 'desc')->get();
        return view('typeintervention.list', compact('datas'));
    }

    /**
     * Show the form for creating a new Http\Response
     */
    public function create()
    {
        return view('typeintervention.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['custom_id'] = $this->generateCustomID();
        $insert = Typeintervention::create($data);
        return (isset($data['ajax'])) ? $insert : $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Typeintervention  $typeintervention
     * @return \Illuminate\Http\Response
     */
    public function show(Typeintervention $typeintervention)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Typeintervention  $typeintervention
     * @return \Illuminate\Http\Response
     */
    public function edit($typeintervention)
    {
        $data = Typeintervention::findBySlug($typeintervention);
        return view('typeintervention.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Typeintervention  $typeintervention
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $typeintervention)
    {
        $typeintervention = Typeintervention::findBySlug($typeintervention);
        $data = $request->all();
        $typeintervention->update($data);
        $typeintervention->save();
        return $this->index();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Typeintervention  $typeintervention
     * @return \Illuminate\Http\Response
     */
    public function destroy(Typeintervention $typeintervention)
    {
        $typeintervention = Typeintervention::findBySlug($typeintervention);
        $typeintervention->delete();
        return $this->index();
    }
}

