<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Trouble;
use Illuminate\Http\Request;

class TroubleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Trouble::orderBy('id', 'desc')->get();
        return view('trouble.list', compact('datas'));
    }

    /**
     * Show the form for creating a new Http\Response
     */
    public function create()
    {
        return view('trouble.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['custom_id'] = $this->generateCustomID();
        $insert = Trouble::create($data);
        return (isset($data['ajax'])) ? $insert : $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Trouble  $trouble
     * @return \Illuminate\Http\Response
     */
    public function show(Trouble $trouble)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Trouble  $trouble
     * @return \Illuminate\Http\Response
     */
    public function edit($trouble)
    {
        $data = Trouble::findBySlug($trouble);
        return view('trouble.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Trouble  $trouble
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $trouble)
    {
        $trouble = Trouble::findBySlug($trouble);
        $data = $request->all();
        $trouble->update($data);
        $trouble->save();
        return $this->index();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Trouble  $trouble
     * @return \Illuminate\Http\Response
     */
    public function destroy($trouble)
    {
        $trouble = Trouble::findBySlug($trouble);
        $trouble->delete();
        return $this->index();
    }
}

