<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Mail\TeleconsultationMail;
use App\Models\Teleconsultation;
use App\Models\Invoice;
use App\Models\Patient;
use App\Models\Product;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class TeleconsultationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(auth()->user()->isTraitant())
            $datas = Teleconsultation::where('user_id', auth()->user()->id)->where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        else
            $datas = Teleconsultation::where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        foreach($datas as $data){
            if($data->patient->archive)
                unset($data);
            $data->type = 'teleconsultation';
        }
        return view('teleconsultation.list', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $patients = Patient::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $users = User::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $products = Product::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('teleconsultation.live', compact('patients',  'users', 'products'));
    }

    public function liveID($patientX)
    {
        $patientX = Patient::findBySlug($patientX);
        $patients = Patient::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $users = User::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $products = Product::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('teleconsultation.live', compact('patients',  'users', 'products', 'patientX'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['company_id'] = auth()->user()->company_id;
        $data['custom_id'] = $this->generateCustomID();
        $data['send_mail'] = isset($data['send_mail']) ? true : false;
        $insert = Teleconsultation::create($data);
        if($insert){
            $totalAll = $insert->amount;

            //create invoice
            $tvaAmount = ($totalAll * 18)/100;
            $totalAmount = $totalAll + $tvaAmount;
            Invoice::create([
                'total' => $totalAmount,
                'tva_amount' => $tvaAmount,
                'amount' => $totalAll,
                'rest_to_pay' => $totalAmount,
                'payed' => 0,
                'date' => date("Y-m-d H:i:s"),
                'user_id' => auth()->user()->id,
                'patient_id' => $insert->patient_id,
                'teleconsultation_id' => $insert->id,
                'sale_id' => isset($sale) ? $sale->id : null,
                'company_id' => auth()->user()->company_id,
                'custom_id' => $this->generateCustomID()
            ]);
            if($data['send_mail']){
                // send teleconsultation mail to patient
                $mailData = [
                    'user' => auth()->user(),
                    'patient' => $insert->patient,
                    'company' => auth()->user()->company,
                    'teleconsultation' => $insert
                ];
                Mail::to($insert->patient)->send(new TeleconsultationMail($mailData));
            }

        }

        return $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Teleconsultation  $teleconsultation
     * @return \Illuminate\Http\Response
     */
    public function show($teleconsultation)
    {
        $teleconsultation = Teleconsultation::findBySlug($teleconsultation);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Teleconsultation  $teleconsultation
     * @return \Illuminate\Http\Response
     */
    public function edit($teleconsultation)
    {
        $data = Teleconsultation::findBySlug($teleconsultation);
        $patients = Patient::where('company_id', auth()->user()->company_id)->get();
        $users = User::where('company_id', auth()->user()->company_id)->get();
        $products = Product::where('company_id', auth()->user()->company_id)->get();
        return view('teleconsultation.edit', compact('data', 'patients', 'users', 'products'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Teleconsultation  $teleconsultation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $teleconsultation)
    {
        $teleconsultation = Teleconsultation::findBySlug($teleconsultation);
        $data = $request->all();
        if(is_null($data['datetime']))
            $data['datetime'] = $teleconsultation->datetime;
        $teleconsultation->update($data);
        return $this->index();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Teleconsultation  $teleconsultation
     * @return \Illuminate\Http\Response
     */
    public function destroy($teleconsultation)
    {
        $teleconsultation = Teleconsultation::findBySlug($teleconsultation);
        $teleconsultation->delete();
        return $this->index();
    }

    public function archive($teleconsultation){
        $teleconsultation = Teleconsultation::findBySlug($teleconsultation);
        $teleconsultation->archive = !$teleconsultation->archive;
        $teleconsultation->save();
        return $this->index();
    }
}
