<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Specialty;
use Illuminate\Http\Request;

class SpecialtyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Specialty::orderBy('id', 'desc')->get();
        return view('specialty.list', compact('datas'));
    }

    /**
     * Show the form for creating a new Http\Response
     */
    public function create()
    {
        return view('specialty.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['custom_id'] = $this->generateCustomID();
        $insert = Specialty::create($data);
        return (isset($data['ajax'])) ? $insert : $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Specialty  $specialty
     * @return \Illuminate\Http\Response
     */
    public function show(Specialty $specialty)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Specialty  $specialty
     * @return \Illuminate\Http\Response
     */
    public function edit($specialty)
    {
        $data = Specialty::findBySlug($specialty);
        return view('specialty.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Specialty  $specialty
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $specialty)
    {
        $specialty = Specialty::findBySlug($specialty);
        $data = $request->all();
        $specialty->update($data);
        $specialty->save();
        return $this->index();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Specialty  $specialty
     * @return \Illuminate\Http\Response
     */
    public function destroy($specialty)
    {
        $specialty = Specialty::findBySlug($specialty);
        $specialty->delete();
        return $this->index();
    }
}

