<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Command;
use App\Models\Invoice;
use App\Models\Product;
use App\Models\Sale;
use Illuminate\Http\Request;

class SaleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Sale::orderBy('id', 'desc')->where('company_id', auth()->user()->company_id)->get();
        foreach($datas as $data){
            foreach($data->commands as $command){
                $command->productName = $command->product->name;
            }
            $data->type = 'sale';
        }
        return view('sale.list', compact('datas'));
    }

    /**
     * Show the form for creating a new Http\Response
     */
    public function create()
    {
        $products = Product::all();
        return view('sale.create', compact('products'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['company_id'] = auth()->user()->company_id;
        $data['custom_id'] = $this->generateCustomID();
        $i = 0; $total = 0;
        $sale = Sale::create([
            'total' => 0,
            'datetime' => date('Y-m-d H:i:s'),
            'user_id' => auth()->user()->id,
            'company_id' => $data['company_id'],
            'custom_id' => $data['custom_id']
        ]);
        foreach($data['product_id'] as $productId){
            $command = Command::create([
                'product_id' => $productId,
                'qte' => $data['qte'][$i],
                'sale_id' => $sale->id,
                'company_id' => $data['company_id']
            ]);
            $total += ($command->product->selling_price * $data['qte'][$i]);
            $command->product->qte -= $data['qte'][$i];
            $command->product->save();
            $i++;
        }
        $sale->total = $total;
        $sale->save();

        //create invoice
        $tvaAmount = ($total * 18)/100;
        $totalAmount = $total + $tvaAmount;
        Invoice::create([
            'total' => $totalAmount,
            'tva_amount' => $tvaAmount,
            'amount' => $total,
            'rest_to_pay' => $totalAmount,
            'payed' => 0,
            'date' => date("Y-m-d H:i:s"),
            'patient_id' => 0,
            'user_id' => auth()->user()->id,
            'sale_id' => $sale->id,
            'company_id' => $data['company_id'],
            'custom_id' => $data['custom_id']
        ]);
        return $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Sale  $sale
     * @return \Illuminate\Http\Response
     */
    public function show(Sale $sale)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Sale  $sale
     * @return \Illuminate\Http\Response
     */
    public function edit($sale)
    {
        $data = Sale::findBySlug($sale);
        return view('sale.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Sale  $sale
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $sale)
    {
        $sale = Sale::findBySlug($sale);
        $data = $request->all();
        $sale->update($data);
        $sale->save();
        return $this->index();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Sale  $sale
     * @return \Illuminate\Http\Response
     */
    public function destroy($sale)
    {
        $sale = Sale::findBySlug($sale);
        $sale->delete();
        return $this->index();
    }
}
