<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Department;
use App\Models\Room;
use Illuminate\Http\Request;

class RoomController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Room::where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        return view('room.list', compact('datas'));
    }

    /**
     * Show the form for creating a new Http\Response
     */
    public function create()
    {
        $departments = Department::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('room.create', compact('departments'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['company_id'] = auth()->user()->company_id;
        $data['custom_id'] = $this->generateCustomID();
        $insert = Room::create($data);
        return (isset($data['ajax'])) ? $insert : $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Room  $room
     * @return \Illuminate\Http\Response
     */
    public function show(Room $room)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Room  $room
     * @return \Illuminate\Http\Response
     */
    public function edit($room)
    {
        $data = Room::findBySlug($room);
        $departments = Department::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('room.edit', compact('data', 'departments'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Room  $room
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $room)
    {
        $room = Room::findBySlug($room);
        $data = $request->all();
        $room->update($data);
        $room->save();
        return $this->index();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Room  $room
     * @return \Illuminate\Http\Response
     */
    public function destroy($room)
    {
        $room = Room::findBySlug($room);
        $room->delete();
        return $this->index();
    }
}

