<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;
use App\Models\Rdv;
use App\Models\Patient;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class RdvController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // Rendez-vous du passé (jusqu'à la fin de la journée d'hier)
        $pasts = Rdv::where('datetime', '<', Carbon::today())
            ->where('company_id', auth()->user()->company_id)
            ->whereHas('patient', function ($query) {
                $query->where('archive', false);
            })
            ->orderBy('id', 'desc');

        // Rendez-vous d'aujourd'hui
        $todays = Rdv::whereBetween('datetime', [Carbon::today(), Carbon::tomorrow()->subSecond()])
            ->where('company_id', auth()->user()->company_id)
            ->whereHas('patient', function ($query) {
                $query->where('archive', false);
            })
            ->orderBy('id', 'desc');

        // Rendez-vous à venir (à partir de demain)
        $comings = Rdv::where('datetime', '>=', Carbon::tomorrow())
            ->where('company_id', auth()->user()->company_id)
            ->whereHas('patient', function ($query) {
                $query->where('archive', false);
            })
            ->orderBy('id', 'desc');

        if(auth()->user()->isTraitant()){
            $pasts = $pasts->where('user_id', auth()->user()->id);
            $todays = $todays->where('user_id', auth()->user()->id);
            $comings = $comings->where('user_id', auth()->user()->id);
        }

        $pasts = $pasts->get();
        $todays = $todays->get();
        $comings = $comings->get();

        $total = $pasts->count() + $todays->count() + $comings->count();

        return view('rdv.list', compact('pasts', 'todays', 'comings', 'total'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $patients = Patient::where('company_id', auth()->user()->company_id)->get();
        $users = User::where('company_id', auth()->user()->company_id)->get();
        return view('rdv.create', compact('patients',  'users'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['company_id'] = auth()->user()->company_id;
        $data['custom_id'] = $this->generateCustomID();
        $data['done'] = 0;
//        if(auth()->user()->isDoctor())
//            $data['user_id'] = auth()->user()->id;
        Rdv::create($data);
        return $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Rdv  $rdv
     * @return \Illuminate\Http\Response
     */
    public function show($rdv)
    {
        $rdv = Rdv::findBySlug($rdv);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Rdv  $rdv
     * @return \Illuminate\Http\Response
     */
    public function edit($rdv)
    {
        $data = Rdv::findBySlug($rdv);
        $patients = Patient::where('company_id', auth()->user()->company_id)->get();
        $users = User::where('company_id', auth()->user()->company_id)->get();
        return view('rdv.edit', compact('data', 'patients', 'users'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Rdv  $rdv
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $rdv)
    {
        $rdv = Rdv::findBySlug($rdv);
        $data = $request->all();
        if(is_null($data['datetime']))
            $data['datetime'] = $rdv->datetime;
        $rdv->update($data);
        return $this->index();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Rdv  $rdv
     * @return \Illuminate\Http\Response
     */
    public function destroy($rdv)
    {
        $rdv = Rdv::findBySlug($rdv);
        $rdv->delete();
        return $this->index();
    }

    public function toggleDone($rdv){
        $rdv = Rdv::findBySlug($rdv);
        $rdv->done = !$rdv->done;
        $rdv->save();
        return $rdv;
    }
}
