<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Group;
use App\Models\Patient;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade as PDF;
use Spatie\Async\Pool;

class PatientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Patient::where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        return view('patient.list', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $groups = Group::orderBy('name')->get();
        return view('patient.create', compact('groups'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['name'] = ucfirst(strtolower($data['firstname'])).' '.strtoupper($data['lastname']);
        $data['archive'] = 0;
        $data['stay'] = 0;
        $data['assured'] = isset($data['assured']) ? true : false;
        $data['company_id'] = auth()->user()->company_id;
        $data['custom_id'] = $this->generateCustomID();
        $insert = Patient::create($data);
        return (isset($data['ajax'])) ? $insert : $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Patient  $patient
     * @return \Illuminate\Http\Response
     */
    public function show($patient)
    {
        $data = Patient::findBySlug($patient);

        $data->lastCares = null;
        if($data->lastIntervention() AND $data->lastIntervention()->cares){
            $data->lastCares = $data->lastIntervention()->cares->pluck('name');
            $data->lastCares = implode(',', $data->lastCares->toArray());
            $data->lastCares = e($data->lastCares);
        }


        // Récupérer la dernière intervention
        $lastIntervention = $data->lastIntervention();
        $sale = $lastIntervention ? $lastIntervention->sale : null;
        $commands = $sale ? $sale->commands : collect(); // Récupérer les commandes ou une collection vide
        $products = collect(); // Initialiser une collection vide pour stocker les noms des produits

        // Itérer sur les commandes pour récupérer les noms des produits
        foreach ($commands as $command) {
            $products = $command->product->pluck('name');
        }

        // Assigner les noms des produits à l'objet $data
        $data->products = $products->unique(); // Garder uniquement les noms uniques
        $data->products = implode(',', $data->products->toArray());
        $data->products = e($data->products);

        return view('patient.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Patient  $patient
     * @return \Illuminate\Http\Response
     */
    public function edit($patient)
    {
        $data = Patient::findBySlug($patient);
        $groups = Group::orderBy('name')->get();
        return view('patient.edit', compact('data', 'groups'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Patient  $patient
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $patient)
    {
        $data = $request->all();
        $patient = Patient::findBySlug($patient);
        $data['name'] = ucfirst(strtolower($data['firstname'])).' '.strtoupper($data['lastname']);
        $data['assured'] = isset($data['assured']) ? true : false;
        $patient->update($data);
        $update = $patient->save();

        return (isset($data['ajax'])) ? $patient : $this->index();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Patient  $patient
     * @return \Illuminate\Http\Response
     */
    public function destroy($patient)
    {
        $patient = Patient::findBySlug($patient);
        $patient->delete();
        return $this->index();
    }

    public function archive($patient){
        $patient = Patient::findBySlug($patient);
        $patient->archive = !$patient->archive;
        $patient->save();
        return $this->index();
    }

    public function downloadTicket($patient)
    {
        $data = Patient::findBySlug($patient);
        auth()->user()->company->currency_symbol = auth()->user()->company->currency_symbol;
        set_time_limit(300);
        $pdf = PDF::loadview('pdfs.invoice-ticket', compact('data'));
        return $pdf->download('KONDY_Ticket-'.$data->id.$data->created_at->format('dmY').'.pdf');
    }

}
