<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Invoice;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade as PDF;

class InvoiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function show($invoice, $type)
    {
        $data = Invoice::findBySlug($invoice);
        setlocale(LC_TIME, "fr_FR");
        if($type == 'intervention'){
            return view('pdfs.invoice-intervention', compact('data'));
        }elseif ($type == 'consultation'){
            return view('pdfs.invoice-consultation',  compact('data'));
        }else{
            return view('pdfs.invoice-sale',  compact('data'));
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function edit($invoice)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Invoice $invoice)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Invoice  $invoice
     * @return \Illuminate\Http\Response
     */
    public function destroy($invoice)
    {
        //
    }

    public function download($invoice, $type)
    {
        $data = Invoice::findBySlug($invoice);
        $company = auth()->user()->company;
//        set_time_limit(300);
        if($type == 'intervention'){
            $pdf = PDF::loadview('pdfs.invoice-intervention', compact('data'));
            return $pdf->download('KONDY_'.$company->name.'_Facture_Hospitalisation-'.$data->no().'.pdf');
        }elseif ($type == 'consultation'){
            $pdf = PDF::loadview('pdfs.invoice-consultation', compact('data'));
            return $pdf->download('KONDY_'.$company->name.'_Facture_Consultation-'.$data->no().'.pdf');
        }elseif ($type == 'prescription'){
            if($data->consultation_id){
                $pdf = PDF::loadview('pdfs.prescription-consultation', compact('data'));
                return $pdf->download('KONDY_'.$company->name.'_Ordonnance_Consultation-'.$data->no().'.pdf');
            }else{
                $data->consultation = $data->teleconsultation;
                $pdf = PDF::loadview('pdfs.prescription-consultation', compact('data'));
                return $pdf->download('KONDY_'.$company->name.'_Ordonnance_Téléconsultation-'.$data->no().'.pdf');
            }
        }elseif ($type == 'teleconsultation') {
            $pdf = PDF::loadview('pdfs.invoice-teleconsultation', compact('data'));
            return $pdf->download('KONDY_'.$company->name.'_Facture_Teleconsultation-' . $data->no() . '.pdf');
        }
        $pdf = PDF::loadview('pdfs.invoice-sale', compact('data'));
        return $pdf->download('KONDY_'.$company->name.'_Facture_Vente-'.$data->no().'.pdf');
    }

    public function generatePDF($invoice, $type)
    {
        $data = Invoice::findBySlug($invoice);

        if ($type == 'teleconsultation') {
            $pdf = PDF::loadview('pdfs.invoice-teleconsultation', compact('data'));
            return $pdf->output();
        }
        if ($type == 'prescription') {
            $data->consultation = $data->teleconsultation;
            $pdf = PDF::loadview('pdfs.prescription-consultation', compact('data'));
            return $pdf->output();
        }
        // Ajoute ici d'autres types si nécessaire
    }

    public function setDiscount($invoice, $discount){
        $invoice = Invoice::find($invoice);
        $invoice->discount = floatval($discount);
        $invoice->save();
        return $invoice;
    }
}
