<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Analysis;
use App\Models\Care;
use App\Models\Command;
use App\Models\Group;
use App\Models\Intervention;
use App\Models\Interventionanalysis;
use App\Models\Interventioncare;
use App\Models\Invoice;
use App\Models\Patient;
use App\Models\Product;
use App\Models\Room;
use App\Models\Sale;
use App\Models\Status;
use App\Models\Trouble;
use App\Models\Typeintervention;
use App\Models\User;
use App\Models\Verdict;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InterventionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(auth()->user()->isTraitant())
            $datas = Intervention::where('user_id', auth()->user()->id)->where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        else
            $datas = Intervention::where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        foreach($datas as $data){
            $data->type = 'intervention';
            if($data->patient->archive)
                unset($data);
        }
        return view('intervention.list', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $patients = Patient::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $typeinterventions = Typeintervention::orderBy('name')->get();
        $troubles = Trouble::orderBy('name')->get();
        $cares = Care::where('company_id', auth()->user()->company_id)->get();
        $statuses = Status::orderBy('name')->get();
        $verdicts = Verdict::orderBy('name')->get();
        $users = User::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $products = Product::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $rooms = Room::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
//        $analyses = Analysis::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $analyses = Analysis::orderBy('name')->get();
        return view('intervention.create', compact('patients', 'typeinterventions', 'troubles', 'statuses', 'verdicts', 'users', 'cares', 'products', 'rooms', 'analyses'));
    }

    public function createID($patientX)
    {
        $patientX = Patient::findBySlug($patientX);
        $patients = Patient::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $typeinterventions = Typeintervention::orderBy('name')->get();
        $troubles = Trouble::orderBy('name')->get();
        $cares = Care::where('company_id', auth()->user()->company_id)->get();
        $statuses = Status::orderBy('name')->get();
        $verdicts = Verdict::orderBy('name')->get();
        $users = User::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $products = Product::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $rooms = Room::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('intervention.create', compact('patients', 'typeinterventions', 'troubles', 'statuses', 'verdicts', 'users', 'cares', 'products', 'rooms', 'patientX'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['company_id'] = auth()->user()->company_id;
        $data['custom_id'] = $this->generateCustomID();
        if($request->file('files')) {
            $data['files'] = $this->storeFiles($request->file('files'));
        }
        if(!$data['datetimefrom'])
            $data['datetimefrom'] = Carbon::now();
//        if(auth()->user()->isDoctor())
//            $data['user_id'] = auth()->user()->id;
        $insert = Intervention::create($data);
        if($insert){
            $totalAll = 0; $c = 0;
            //create interventioncare
            foreach($data['care_id'] as $careId){
                $interventionCare = Interventioncare::create([
                    'intervention_id' => $insert->id,
                    'care_id' => $careId,
                    'price' => $data['price'][$c]
                ]);
                $totalAll += $data['price'][$c];
                $c++;
            }
            //create interventionanalysis
            $r = 0;
            foreach($data['analysis_id'] as $analysisId){
                $interventionanalysis = Interventionanalysis::create([
                    'intervention_id' => $insert->id,
                    'analysis_id' => $analysisId,
                    'result' => $data['result'][$r]
                ]);
                $analysis = Analysis::find($analysisId);
                $totalAll += $analysis->amount;
                $r++;
            }
            //create sale
            if(isset($data['product_id'][0]) AND !is_null($data['product_id'][0])){
                $i = 0; $total = 0;
                $sale = Sale::create([
                    'total' => 0,
                    'datetime' => date('Y-m-d H:i:s'),
                    'user_id' => auth()->user()->id,
                    'company_id' => auth()->user()->company_id,
                    'custom_id' => $this->generateCustomID()
                ]);
                foreach($data['product_id'] as $productId){
                    $command = Command::create([
                        'product_id' => $productId,
                        'qte' => $data['qte'][$i],
                        'sale_id' => $sale->id,
                        'company_id' => auth()->user()->company_id
                    ]);
                    $total += ($command->product->selling_price * $data['qte'][$i]);
                    $command->product->qte -= $data['qte'][$i];
                    $command->product->save();
                    $i++;
                }
                $sale->total = $total;
                $sale->save();
                $insert->sale_id = $sale->id;
                $insert->save();
                $totalAll += $total;
            }

            if(intval($data['enableInvoice']) == 1){
                //create invoice
                $tvaAmount = ($totalAll * 18) / 100;
                if(auth()->user()->company->tva)
                    $totalAmount = $totalAll + $tvaAmount + ($insert->room->price * $insert->days());
                else
                    $totalAmount = $totalAll + ($insert->room->price * $insert->days());
                Invoice::create([
                    'total' => $totalAmount,
                    'tva_amount' => $tvaAmount,
                    'amount' => $totalAll,
                    'rest_to_pay' => $totalAmount,
                    'payed' => 0,
                    'date' => date("Y-m-d H:i:s"),
                    'user_id' => auth()->user()->id,
                    'patient_id' => $insert->patient_id,
                    'intervention_id' => $insert->id,
                    'sale_id' => isset($sale) ? $sale->id : null,
                    'company_id' => auth()->user()->company_id,
                    'custom_id' => $this->generateCustomID()
                ]);
            }


        }
        return $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Intervention  $intervention
     * @return \Illuminate\Http\Response
     */
    public function show($intervention)
    {
        $data = Intervention::findBySlug($intervention);
        return view('intervention.show', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Intervention  $intervention
     * @return \Illuminate\Http\Response
     */
    public function edit($intervention)
    {
        $data = Intervention::findBySlug($intervention);;
        $patients = Patient::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $typeinterventions = Typeintervention::orderBy('name')->get();
        $troubles = Trouble::orderBy('name')->get();
        $cares = Care::where('company_id', auth()->user()->company_id)->get();
        $statuses = Status::orderBy('name')->get();
        $verdicts = Verdict::orderBy('name')->get();
        $users = User::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $products = Product::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $rooms = Room::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('intervention.edit', compact('data', 'patients', 'typeinterventions', 'troubles', 'statuses', 'verdicts', 'users', 'cares', 'products', 'rooms'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Intervention  $intervention
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $intervention)
    {
        $data = $request->all();
        $intervention = Intervention::findBySlug($intervention);
        if($request->file('files'))
            $data['files'] = $this->storeFiles($request->file('files'));
        if(is_null($data['datetimefrom']))
            $data['datetimefrom'] = $intervention->datetimefrom;
        $update = $intervention->update($data);

        if($update AND !$intervention->invoice()) {
            $totalAll = 0; $c = 0;
            // delete old interventioncare
            DB::table('interventioncares')->where('intervention_id', $intervention->id)->delete();
            //create new interventioncare
            foreach ($data['care_id'] as $careId) {
                $interventionCare = Interventioncare::create([
                    'intervention_id' => $intervention->id,
                    'care_id' => $careId,
                    'price' => $data['price'][$c]
                ]);
                $totalAll += $interventionCare->amount();
            }
            // delete old sale
            DB::table('sales')->where('id', $intervention->sale_id)->delete();
            //create new sale
            if(isset($data['product_id'][0]) AND !is_null($data['product_id'][0])){
                $i = 0;
                $total = 0;
                $sale = Sale::create([
                    'total' => 0,
                    'datetime' => date('Y-m-d H:i:s'),
                    'user_id' => auth()->user()->id,
                    'company_id' => auth()->user()->company_id,
                    'custom_id' => $this->generateCustomID()
                ]);
                foreach ($data['product_id'] as $productId) {
                    $command = Command::create([
                        'product_id' => $productId,
                        'qte' => $data['qte'][$i],
                        'sale_id' => $sale->id,
                        'company_id' => auth()->user()->company_id
                    ]);
                    $total += ($command->product->selling_price * $data['qte'][$i]);
                    $command->product->qte -= $data['qte'][$i];
                    $command->product->save();
                    $i++;
                }
                $sale->total = $total;
                $sale->save();
                $intervention->sale_id = $sale->id;
                $intervention->save();
                $totalAll += $total;
            }
            if (intval($data['enableInvoice']) == 1) {
                //create invoice
                $tvaAmount = ($totalAll * 18) / 100;
                $days = $update->datetimeto ? $update->datetimefrom->diffInDays($update->datetimeto) : 1;
                if(auth()->user()->company->tva)
                    $totalAmount = $totalAll + $tvaAmount + ($update->room->price * $update->days());
                else
                    $totalAmount = $totalAll + ($update->room->price * $update->days());
                Invoice::create([
                    'total' => $totalAmount,
                    'tva_amount' => $tvaAmount,
                    'amount' => $totalAll,
                    'rest_to_pay' => $totalAmount,
                    'payed' => 0,
                    'date' => date("Y-m-d H:i:s"),
                    'user_id' => auth()->user()->id,
                    'patient_id' => $intervention->patient_id,
                    'intervention_id' => $intervention->id,
                    'sale_id' => isset($sale) ? $sale->id : null,
                    'company_id' => auth()->user()->company_id,
                    'custom_id' => $this->generateCustomID()
                ]);
            }
        }
        return $this->index();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Intervention  $intervention
     * @return \Illuminate\Http\Response
     */
    public function destroy($intervention)
    {
        $intervention = Intervention::findBySlug($intervention);
        $intervention->delete();
        return $this->index();
    }

    public function archive($intervention){
        $intervention = Intervention::findBySlug($intervention);
        $intervention->archive = !$intervention->archive;
        $intervention->save();
        return $this->index();
    }

    private function storeFiles($files){
        $filename = [];
        foreach($files as $file){
            $name = $file->hashName();
            $file->move(storage_path('app/public/uploads/interventions'), $name);
            $filename[] = $name;
        }
        return implode(';', $filename);
    }

}
