<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Google_Client;
use Google_Service_Calendar;
use Google_Service_Calendar_Event;

class GoogleApiController extends Controller
{
    public function createGoogleMeet()
    {
        // Vérifier que l'utilisateur est bien authentifié avec un token Google valide
        if (!session('google_token')) {
            return redirect()->route('oauth'); // Rediriger vers la page d'authentification Google si le token est manquant
        }

        // Initialiser le client Google
        $client = new Google_Client();
        $client->setAuthConfig(storage_path('app/credentials/google_api_client_secret.json'));
        $client->setAccessToken(session('google_token'));

        // Vérifier si le token est expiré et rafraîchir le token d'accès si nécessaire
        if ($client->isAccessTokenExpired()) {
            if ($client->getRefreshToken()) {
                $newToken = $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
                session(['google_token' => $client->getAccessToken()]);
            } else {
                return redirect()->route('oauth'); // Si pas de refresh token, rediriger vers la ré-authentification
            }
        }

        // Initialiser le service Google Calendar
        $service = new Google_Service_Calendar($client);

        // Créer un événement Google Meet
        $event = new Google_Service_Calendar_Event([
            'summary' => 'Téléconsultation via Google Meet',
            'start' => ['dateTime' => '2024-10-16T10:00:00-07:00'],  // À adapter à ta logique
            'end' => ['dateTime' => '2024-10-16T10:30:00-07:00'],    // À adapter à ta logique
            'conferenceData' => [
                'createRequest' => [
                    'requestId' => 'uniqueRequestId_' . time(),  // Assurez-vous que l'ID de la requête est unique
                    'conferenceSolutionKey' => ['type' => 'hangoutsMeet'],
                    'status' => ['statusCode' => 'success'],
                ],
            ],
        ]);

        // Insérer l'événement dans Google Calendar avec la version de conférence Meet activée
        try {
            $createdEvent = $service->events->insert('primary', $event, ['conferenceDataVersion' => 1]);

            // Vérifier si le lien Meet est généré et le retourner
            $meetLink = $createdEvent->hangoutLink;
            if ($meetLink) {
                return response()->json(['meet_link' => $meetLink]);
            } else {
                return response()->json(['error' => 'Le lien Google Meet n\'a pas été généré.'], 500);
            }
        } catch (\Exception $e) {
            // Gestion des erreurs
            return response()->json(['error' => 'Erreur lors de la création de l\'événement : ' . $e->getMessage()], 500);
        }
    }

    // Rediriger l'utilisateur vers la page d'authentification Google
    public function redirectToGoogle(Request $request)
    {
        $client = new Google_Client();
        $client->setAuthConfig(storage_path('app/credentials/google_api_client_secret.json'));
        $client->setRedirectUri(route('oauth2callback'));
        $client->addScope(Google_Service_Calendar::CALENDAR); // Demander l'accès à Google Calendar

        // Générer l'URL de connexion OAuth et rediriger
        $auth_url = $client->createAuthUrl();
        return redirect($auth_url);
    }

    // Gérer la réponse de Google après authentification
    public function handleGoogleCallback(Request $request)
    {
        $client = new Google_Client();
        $client->setAuthConfig(storage_path('app/credentials/google_api_client_secret.json'));
        $client->setRedirectUri(route('oauth2callback'));

        // Échanger le code d'autorisation pour un token d'accès
        $token = $client->fetchAccessTokenWithAuthCode($request->input('code'));

        // Stocker le token dans la session
        session(['google_token' => $token]);

        // Rediriger vers une page protégée
        return redirect(route('index'));
    }
}
