<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;
use App\Models\Dashboard;

use Carbon\Carbon;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(Request $request){
        $company = auth()->user()->company;
//        if($company->subscription AND $company->subscription->name == 'basic')
//            return redirect(route('company.edit', $company->custom_id));

        $dateStart = (!$request->get('datestart')) ? date('Y-m-01') : $request->get('datestart');
        $dateEnd = (!$request->get('dateend')) ? date('Y-m-d') : $request->get('dateend');

        $dashboard = new Dashboard(['dateStart' => $dateStart, 'dateEnd' => $dateEnd]);
        $rdvs = $dashboard->rdvs();
        $patients = $dashboard->patients();
        $operations = $dashboard->operations();
        $recipe = $dashboard->recipe();
        $interventions = $dashboard->interventions();
        $consultations = $dashboard->consultations();

//        $dateStart = date('d/m/Y', strtotime($dateStart));
//        $dateEnd = date('d/m/Y', strtotime($dateEnd));

        $dateStart = Carbon::parse($dateStart)->translatedFormat('D d F Y');
        $dateEnd = Carbon::parse($dateEnd)->translatedFormat('D d F Y');

        if(password_verify(auth()->user()->firstname(), auth()->user()->password))
            return redirect()->route('users.edit', auth()->user()->custom_id);

        $currency_symbol = auth()->user()->company->currency_symbol;

        return view('dashboard', compact('dashboard', 'rdvs', 'patients', 'operations', 'recipe', 'dateStart', 'dateEnd', 'currency_symbol', 'interventions', 'consultations'));
    }
}
