<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Command;
use App\Models\Consultation;
use App\Models\Invoice;
use App\Models\Patient;
use App\Models\Product;
use App\Models\Sale;
use App\Models\User;
use Illuminate\Http\Request;

class ConsultationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if(auth()->user()->isTraitant())
            $datas = Consultation::where('user_id', auth()->user()->id)->where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        else
            $datas = Consultation::where('company_id', auth()->user()->company_id)->orderBy('id', 'desc')->get();
        foreach($datas as $data){
            if($data->patient->archive)
                unset($data);
            $data->type = 'consultation';
        }
        return view('consultation.list', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $patients = Patient::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $users = User::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $products = Product::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('consultation.create', compact('patients',  'users', 'products'));
    }

    public function createID($patientX)
    {
        $patientX = Patient::findBySlug($patientX);
        $patients = Patient::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $users = User::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        $products = Product::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('consultation.create', compact('patients',  'users', 'products', 'patientX'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['company_id'] = auth()->user()->company_id;
        $data['custom_id'] = $this->generateCustomID();
//        if(auth()->user()->isDoctor())
//            $data['user_id'] = auth()->user()->id;
        $insert = Consultation::create($data);
        if($insert){
            $totalAll = $insert->amount;
//            if(!is_null($data['product_id'][0])){
//                $i = 0; $total = 0;
//                $sale = Sale::create([
//                    'total' => 0,
//                    'datetime' => date('Y-m-d H:i:s'),
//                    'user_id' => 1
////                    'user_id' => auth()->user()->id
//                ]);
//                foreach($data['product_id'] as $productId){
//                    $command = Command::create([
//                        'product_id' => $productId,
//                        'qte' => $data['qte'][$i],
//                        'sale_id' => $sale->id
//                    ]);
//                    $total += ($command->product->selling_price * $data['qte'][$i]);
//                    $command->product->qte -= $data['qte'][$i];
//                    $command->product->save();
//                    $i++;
//                }
//                $sale->total = $total;
//                $sale->save();
//                $totalAll += $total;
//            }
            //create invoice
            $tvaAmount = ($totalAll * 18)/100;
            $totalAmount = $totalAll + $tvaAmount;
            Invoice::create([
                'total' => $totalAmount,
                'tva_amount' => $tvaAmount,
                'amount' => $totalAll,
                'rest_to_pay' => $totalAmount,
                'payed' => 0,
                'date' => date("Y-m-d H:i:s"),
                'user_id' => auth()->user()->id,
                'patient_id' => $insert->patient_id,
                'consultation_id' => $insert->id,
                'sale_id' => isset($sale) ? $sale->id : null,
                'company_id' => auth()->user()->company_id,
                'custom_id' => $this->generateCustomID()
            ]);
        }

        return $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Consultation  $consultation
     * @return \Illuminate\Http\Response
     */
    public function show($consultation)
    {
        $consultation = Consultation::findBySlug($consultation);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Consultation  $consultation
     * @return \Illuminate\Http\Response
     */
    public function edit($consultation)
    {
        $data = Consultation::findBySlug($consultation);
        $patients = Patient::where('company_id', auth()->user()->company_id)->get();
        $users = User::where('company_id', auth()->user()->company_id)->get();
        $products = Product::where('company_id', auth()->user()->company_id)->get();
        return view('consultation.edit', compact('data', 'patients', 'users', 'products'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Consultation  $consultation
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $consultation)
    {
        $consultation = Consultation::findBySlug($consultation);
        $data = $request->all();
        if(is_null($data['datetime']))
            $data['datetime'] = $consultation->datetime;
        $consultation->update($data);
        return $this->index();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Consultation  $consultation
     * @return \Illuminate\Http\Response
     */
    public function destroy($consultation)
    {
        $consultation = Consultation::findBySlug($consultation);
        $consultation->delete();
        return $this->index();
    }

    public function archive($consultation){
        $consultation = Consultation::findBySlug($consultation);
        $consultation->archive = !$consultation->archive;
        $consultation->save();
        return $this->index();
    }
}
