<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Company;
use App\Models\Subscription;
use App\Models\SubscriptionInvoice;
use Carbon\Carbon;
use Illuminate\Http\Request;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['custom_id'] = $this->generateCustomID();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function show($company)
    {
        $company = Company::findBySlug($company);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function edit($company)
    {
        $data = Company::findBySlug($company);
        return view('company.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $company)
    {
        $company = Company::findBySlug($company);
        $data = $request->all();
        $data['tva'] = (isset($data['tva'])) ? true : false;
        if($request->file('logo')) {
            $data['logo'] = $this->storeFile($request->file('logo'));
        }
        if($request->file('signature')) {
            $data['signature'] = $this->storeFile($request->file('signature'));
        }

        // set currencies
        $currencyData = $this->setCurrency($data['country']);
        $data['currency'] = $currencyData[0];
        $data['currency_symbol'] = $currencyData[1];

        // set TVA
        $data['tva_value'] = $this->setTVA($data['country']);

        $company->update($data);
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function destroy(Company $company)
    {
        $company = Company::findBySlug($company);
    }

    private function storeFile($file){
        $name = $file->hashName();
        $file->move(storage_path('app/public/uploads/company'), $name);
        return $name;
    }

    public function updateAiCredits(){
        if(auth()->user()->subStandard()  AND !auth()->user()->subGold()){
            auth()->user()->company->ai_credits--;
            if(auth()->user()->company->ai_credits < 0)
                auth()->user()->company->ai_credits = 0;
            auth()->user()->company->save();
            return auth()->user()->company->ai_credits;
        }
        return false;
    }

}
