<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\controller;

use App\Models\Care;
use Illuminate\Http\Request;

class CareController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Care::where('company_id', auth()->user()->company_id)->orderBy('name')->get();
        return view('care.list', compact('datas'));
    }

    /**
     * Show the form for creating a new Http\Response
     */
    public function create()
    {
        return view('care.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();
        $data['custom_id'] = $this->generateCustomID();
        $data['company_id'] = auth()->user()->company_id;
        $insert = Care::create($data);
        return (isset($data['ajax'])) ? $insert : $this->index();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Care  $care
     * @return \Illuminate\Http\Response
     */
    public function show($care)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Care  $care
     * @return \Illuminate\Http\Response
     */
    public function edit($care)
    {
        $data = Care::findBySlug($care);
        return view('care.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Care  $care
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $care)
    {
        $data = $request->all();
        $care = Care::findBySlug($care);
        $care->update($data);
        $care->save();
        return $this->index();
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Care  $care
     * @return \Illuminate\Http\Response
     */
    public function destroy(Care $care)
    {
        $care = Care::findBySlug($care);
        $care->delete();
        return $this->index();
    }
}

