<?php

namespace App\Console;

use Carbon\Carbon;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        \App\Console\Commands\SendRdvMail::class,
        \App\Console\Commands\SendStatMail::class,
    ];

    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $timezone = 'UTC'; // Remplace ceci par le fuseau horaire de l'utilisateur

        // Exécuter la commande mail:rdv chaque jour à 00h
        $schedule->command('mail:rdv')
            ->timezone($timezone)  // Utilise le fuseau horaire local de l'utilisateur
            ->dailyAt('00:10')          // Exécution quotidienne à minuit
            ->withoutOverlapping();

        // Exécuter la commande mail:stat chaque fin de mois à 23h50
        $schedule->command('mail:stat')
            ->timezone($timezone)  // Utilise le fuseau horaire local de l'utilisateur
            ->lastDayOfMonth()          // Exécution le dernier jour du mois
            ->at('23:50')               // À 23h50
            ->withoutOverlapping();
    }


    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
