<?php

namespace App\Console\Commands;

use App\Mail\StatMail;
use App\Models\Dashboard;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Mail;

class SendStatMail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:stat';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Envoie un mail de stats du mois précédent aux administrateurs';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Définir la locale en français
        Carbon::setLocale('fr');
        // Logique pour récupérer et envoyer les stats du mois dernier
        $lastMonth = ucfirst(Carbon::now()->translatedFormat('F Y')); // Mois précédent en lettre
        $lastMonthKey = Carbon::now()->format('m'); // Mois précédent en chiffres

        // Exemple d'envoi de mail

        $subscribers = User::all()->filter(function ($user) {
            if($user->company->subscription_active)
                return $user->isSubscriber(); // Récupérer tous les administrateurs actifs
        });

        foreach ($subscribers as $subscriber) {
            $mailData = [
                'user' => $subscriber,
                'lastMonth' => $lastMonth,
                'lastMonthKey' => $lastMonthKey,
                'company' => $subscriber->company,
                'stats' => new Dashboard(['dateStart' => date('Y-m-01'), 'dateEnd' => date('Y-m-d'), 'company' => $subscriber->company]),
            ];
            Mail::to($subscriber)->send(new StatMail($mailData));
        }

        $this->info('E-mails de statistiques envoyés avec succès.');
    }
}
