<?php

namespace App\Console\Commands;

use App\Mail\RdvMail;
use App\Models\Dashboard;
use App\Models\Rdv;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class SendRdvMail extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mail:rdv';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // Définir la date d'aujourd'hui
        $today = Carbon::today();

        // Récupérer tous les utilisateurs
        $users = User::all()->filter(function($user){
            return $user->company->where('subscription_active', 1);
        });

        foreach ($users as $user) {
            // Récupérer les rendez-vous du jour pour l'utilisateur
//            $rdvs = $user->rdvs()->whereBetween('datetime', [Carbon::today(), Carbon::tomorrow()->subSecond()])->with('patient')->get();
            $rdvs = $user->rdvs()->with('patient')->get();

            // Vérifier si l'utilisateur a au moins un rendez-vous
            if ($rdvs->isNotEmpty()) {
                // Préparer les données pour l'email
                $mailData = [
                    'user' => $user,
                    'company' => $user->company,
                    'rdvs' => $rdvs,
                ];

                // Ajouter un log avant d'envoyer l'email
                Log::info("Envoi de l'email pour l'utilisateur: " . $user->email);

                // Envoyer l'email
//                if($user == auth()->user())
                    Mail::to('mamama@gmail.com')->send(new RdvMail($mailData));
                    break;
            }
        }

        $this->info('Emails des rendez-vous du jour envoyés avec succès aux utilisateurs ayant des rendez-vous.');
    }
}
